# Keyzy WooCommerce Integration

A WordPress plugin that integrates WooCommerce stores with the Keyzy (app.keyzy.io) license management service.

## Requirements

- WordPress 5.0+
- WooCommerce 5.0+
- PHP 7.4+
- Keyzy account (app.keyzy.io)

## Installation

1. Upload plugin files to `/wp-content/plugins/keyzywc` directory
2. Run `composer install` (for vendor dependencies)
3. WordPress Admin > Plugins > Activate "Keyzy WooCommerce Integration"
4. Configure API settings at Settings > Keyzy Settings

## Settings

Configured via **Settings > Keyzy Settings**:

| Setting | Description |
|---------|-------------|
| APP ID | App ID from app.keyzy.io > App Keys section (write/admin permission required) |
| API KEY | API Key from app.keyzy.io > App Keys section (write/admin permission required) |
| Show Download Link | Show/hide license file download link |
| Show Host ID Input Field | Show/hide Host ID input field |
| Show Manageable Activations to Users | Allow users to manage their activations |
| Disable Register Product Notification | Disable WooCommerce email notifications for Register Product |

## Shortcodes

### [keyzy-downloads]
Displays the customer's purchased product licenses and download links.

### [keyzy-register-product]
Allows customers to register products purchased from other channels (dealers, distributors) by entering the serial number.

### [keyzy-upgrade]
Enables license upgrades.

## Customizing the Downloads Page Appearance

The `[keyzy-downloads]` shortcode output uses CSS classes so you can easily customize the appearance to match your theme.

**CSS classes:**

- `.keyzy-sku-block` — Wrapper for each license/SKU (separated by a 2px border)
- `.keyzy-product-block` — Wrapper for each product within a SKU (separated by a 1px border)
- `.keyzy-activation-row` — Each activation entry under a product

**Example overrides:**

```css
/* Remove borders between products */
.keyzy-product-block { border-top: none; }

/* Custom SKU separator */
.keyzy-sku-block { border-top: 3px solid #333; margin-top: 30px; }

/* Increase activation indent */
.keyzy-activation-row { margin-left: 20px; }
```

No changes needed on your end — everything works out of the box with sensible defaults.

## Automatic License Assignment

When an order status changes to "Completed", the plugin automatically:
1. Reserves a license from Keyzy for each product in the order
2. Assigns the license to the customer's account
3. Supports quantity - 5 items ordered = 5 licenses reserved

---

# Manual Testing Steps

## Prerequisites

1. WordPress + WooCommerce installed and running
2. Keyzy account with valid APP ID / API KEY
3. At least one product and license pool defined in Keyzy
4. WooCommerce product(s) with SKU matching Keyzy SKU
5. Test customer account

---

## Test 1: Plugin Activation and Settings

### 1.1 Plugin Activation
1. Go to WordPress Admin > Plugins
2. Click "Activate" next to "Keyzy WooCommerce Integration"
3. **Expected:** Plugin activates without errors, Settings > Keyzy Settings menu appears

### 1.2 Settings Page Access
1. Go to Settings > Keyzy Settings
2. **Expected:** All setting fields are visible (APP ID, API KEY, 4 checkboxes)

### 1.3 Save API Settings
1. Enter valid App ID in APP ID field
2. Enter valid API Key in API KEY field
3. Click "Save Changes"
4. **Expected:** Settings are saved, values persist after page refresh

### 1.4 Invalid API Settings
1. Shorten APP ID to 7 characters (minimum 8 required)
2. Save and go to a page with [keyzy-downloads] shortcode
3. **Expected:** "Plugin configuration error. Please contact the administrator." message appears

---

## Test 2: Order Completion and Automatic License Assignment

### 2.1 Create New Order
1. Log in with customer account
2. Add a product with Keyzy SKU to cart
3. Complete checkout
4. **Expected:** Order is created (Processing status)

### 2.2 Complete Order
1. Go to Admin > WooCommerce > Orders
2. Open the created order
3. Change status to "Completed" and save
4. **Expected:**
   - License reserve request is sent to Keyzy API
   - License is assigned to customer in app.keyzy.io

### 2.3 Quantity Test
1. Order 3 of the same product
2. Complete the order
3. **Expected:** 3 separate licenses are reserved in Keyzy

---

## Test 3: [keyzy-downloads] Shortcode

### 3.1 Not Logged In User
1. Log out
2. Go to page with [keyzy-downloads] shortcode
3. **Expected:** "Whoops! It looks like you aren't logged in..." message appears

### 3.2 User With No Orders
1. Log in with a new user account (no orders)
2. Go to page with [keyzy-downloads] shortcode
3. **Expected:** "You do not have any products available..." message and shop link appears

### 3.3 User With Licenses
1. Log in with customer account that has completed orders
2. Go to page with [keyzy-downloads] shortcode
3. **Expected:**
   - "My Products" heading appears
   - Product image is displayed
   - Product Serial number is displayed

---

## Test 4: Show Download Link Setting

### 4.1 Download Link Enabled
1. Go to Admin > Settings > Keyzy Settings
2. Check "Show Download Link" checkbox
3. Save
4. Go to [keyzy-downloads] page as customer
5. **Expected:** "Download [Product] License File" link is visible

### 4.2 Download Link Disabled
1. Go to Admin > Settings > Keyzy Settings
2. Uncheck "Show Download Link" checkbox
3. Save
4. Go to [keyzy-downloads] page as customer
5. **Expected:** Download link is not visible, only serial number shown

---

## Test 5: Show Host ID Input Field Setting

### 5.1 Host ID Enabled
1. Go to Admin > Settings > Keyzy Settings
2. Check both "Show Download Link" AND "Show Host ID Input Field" checkboxes
3. Save
4. Go to [keyzy-downloads] page as customer
5. **Expected:**
   - "Host ID:" label and text input field are visible
   - Download link is initially disabled

### 5.2 Host ID Validation
1. Enter invalid value in Host ID field (too short)
2. **Expected:** Input border turns red, download link is not clickable

### 5.3 Download with Host ID
1. Enter valid value in Host ID field
2. **Expected:** Input border returns to normal, download link becomes active
3. Click download link
4. **Expected:** License file downloads, host_id parameter is in URL

### 5.4 Host ID Disabled
1. Uncheck "Show Host ID Input Field" in Admin
2. Save
3. Go to page as customer
4. **Expected:** Host ID field is not visible, download link is directly active

---

## Test 6: Show Manageable Activations to Users Setting

### 6.1 Activations Enabled
1. First create at least one activation for this license in Keyzy
2. Go to Admin > Settings > Keyzy Settings
3. Check "Show Manageable Activations to Users" checkbox
4. Save
5. Go to [keyzy-downloads] page as customer
6. **Expected:**
   - Activation information is visible (Host ID, Device Tag)
   - "Delete Activation" link is visible

### 6.2 Delete Activation
1. Click "Delete Activation" link
2. **Expected:** Confirmation dialog appears
3. Click "OK"
4. **Expected:** Activation is deleted, page refreshes, activation removed from list

### 6.3 Activations Disabled
1. Uncheck "Show Manageable Activations to Users" in Admin
2. Save
3. Go to page as customer
4. **Expected:** Activation information and delete link are not visible

---

## Test 7: [keyzy-register-product] Shortcode

### 7.1 Register Product Page
1. Log in with customer account
2. Go to page with [keyzy-register-product] shortcode
3. **Expected:** Serial number input form is visible

### 7.2 Register Valid Serial Number
1. Enter a serial number that exists in Keyzy and is not yet assigned
2. Submit
3. **Expected:**
   - Success message appears
   - Internal order with $0 total is created in WooCommerce
   - License is assigned to user

### 7.3 Invalid Serial Number
1. Enter invalid or already assigned serial number
2. Submit
3. **Expected:** Error message appears

---

## Test 8: Disable Register Product Notification Setting

### 8.1 Notification Enabled (default)
1. Go to Admin > Settings > Keyzy Settings
2. Ensure "Disable Register Product Notification" checkbox is unchecked
3. Save
4. Register a product using [keyzy-register-product]
5. **Expected:** WooCommerce order notification email is sent (to admin and/or customer)

### 8.2 Notification Disabled
1. Go to Admin > Settings > Keyzy Settings
2. Check "Disable Register Product Notification" checkbox
3. Save
4. Register a product using [keyzy-register-product]
5. **Expected:** WooCommerce order notification email is NOT sent

---

## Test 9: [keyzy-upgrade] Shortcode

### 9.1 Upgrade Page
1. Log in with customer account
2. Go to page with [keyzy-upgrade] shortcode
3. **Expected:** Upgrade form is visible

### 9.2 License Upgrade
1. Enter existing serial number
2. Select upgrade option
3. Submit
4. **Expected:** Upgrade process starts or item is added to cart

---

## Test 10: Error Conditions

### 10.1 Keyzy API Unreachable
1. Change API URL to invalid address in defines.php
2. Go to [keyzy-downloads] page
3. **Expected:** "Error fetching license data. Please try again later." message appears
4. **Cleanup:** Restore API URL to original value

### 10.2 Product SKU Not in Keyzy
1. Create a product in WooCommerce with SKU that doesn't exist in Keyzy
2. Order this product and complete order
3. **Expected:** Order completes but license is not assigned (error is logged)

---

## Test 11: HPOS Compatibility

### 11.1 HPOS Active Test
1. Go to WooCommerce > Settings > Advanced > Features
2. Enable "High-Performance Order Storage"
3. Repeat all order tests (Test 2)
4. **Expected:** All operations work with HPOS enabled

---

## Running Unit Tests

```bash
cd wp-content/plugins/keyzywc
./vendor/bin/phpunit tests/
```

**Expected:** All tests pass (65 tests, 101 assertions)

---

## Troubleshooting

### License not being assigned
- Verify APP ID and API KEY are correct
- Verify license pool has available licenses in Keyzy
- Verify WooCommerce product SKU matches Keyzy SKU
- Check `wp-content/debug.log` file

### Download link not working
- Verify "Show Download Link" setting is enabled
- If Host ID is required, verify a valid value is entered

### Email notifications not sending/sending
- Check "Disable Register Product Notification" setting
- Check WooCommerce email settings