<?php

/*
 * --------------------------------------------------------------------------
 * CONFIGURATION LOADER
 * --------------------------------------------------------------------------
 * Logic:
 * 1. Check if a local configuration file ('local-config.php') exists in the same directory.
 * This file is strictly for development environments and is ignored by Git.
 * 2. If it exists, load settings (URL, SSL Verify) from there.
 * 3. If NOT, fall back to secure Production defaults.
 */

$local_config_path = dirname(__FILE__) . '/local-config.php';

if ( file_exists( $local_config_path ) ) {
    // Load local settings (This file should define KEYZYURL and SSL_VERIFY)
    include_once $local_config_path;
}

// --------------------------------------------------------------------------
// PRODUCTION DEFAULTS (FALLBACK)
// --------------------------------------------------------------------------

// If KEYZYURL wasn't defined by local-config.php, use the Production URL.
if ( ! defined( 'KEYZYURL' ) ) {
    define( 'KEYZYURL', 'https://api.keyzy.io/v2/' );
}

// If SSL_VERIFY wasn't defined by local-config.php, enforce SSL verification.
if ( ! defined( 'SSL_VERIFY' ) ) {
    define( 'SSL_VERIFY', true );
}

// --------------------------------------------------------------------------
// CONSTANTS & REGEX
// --------------------------------------------------------------------------

define( 'KEYZYWC_VERSION', '1.4.2' );
define( 'HOST_ID_LENGTH', 64 ); // Expected length of host_id

// Regex pattern, using HOST_ID_LENGTH. The pattern is lowercase hexadecimal; set to '' to disable validation.
// The regex is written without the / delimiters, as they'll be added in JavaScript.
define( 'HOST_ID_REGEX', '^[0-9a-f]{' . HOST_ID_LENGTH . '}$' );

/*
 * Connection array configuration used for Guzzle client.
 * NOTE: This variable must be declared as 'global $connection_array;'
 * inside any function that uses it (e.g., in ajax callbacks).
 */
global $connection_array;
$connection_array = [
    'base_uri'    => KEYZYURL,
    'timeout'     => 30.0,
    'http_errors' => false,
    'verify'      => SSL_VERIFY
];

?>
