<?php
require_once dirname(__FILE__).'/../defines.php';
global $connection_array; // from defines.php
global $wp; // for $wp->request using in addEventListener

/**
 * Error Message notes
 * Normally we shouldn't have the "The serial number is not valid!" error because we already check the length of the serial number here.
 */

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['serial'])) {
    header('Content-Type: application/json'); // Ensure the content type is JSON
    $serial = $_POST['serial'];

    // get app_id and api_key
    $optionInfo = get_option( 'keyzy_option_name', 'null' );

    // Keyzy app_id and api_key
    $app_id = $optionInfo['app_id'];
    $api_key = $optionInfo['api_key'];

    // $res = '';
    $statusCode = 0;
    $body = '';
    try {
        $url = $connection_array['base_uri'] . 'register-products/' . $serial;
        $response = wp_remote_get(
            $url,
            [
                'timeout' => $connection_array['timeout'],
                'sslverify' => $connection_array['verify'],
                'body'    => [
                    'app_id' => $app_id,
                    'api_key' => $api_key
                ]
            ]
        );

        if (is_wp_error($response)) {
            throw new Exception($response->get_error_message());
        }

        $statusCode = wp_remote_retrieve_response_code($response);
        $body = wp_remote_retrieve_body($response);
        if ($statusCode !== 200) {
            $errorStr = '';
            if ($statusCode === 422) {
                $errorStr = "The serial number is not valid!";
            }
            else if ($statusCode === 404) {
                $errorStr = "Wrong serial number!";
            }
            else if ($statusCode === 401) {
                $errorStr = "You are not authorized!";
            }
            else {
                $errorStr = "Unknown Error! Status code is $statusCode";
            }

            error_log('register-products GET errorStr: ' . $errorStr);
            wp_send_json_error(['message' => $errorStr]);
        }

    } catch (Exception $e) {
        error_log('Error Message: ' . $e->getMessage());
        wp_send_json_error(['message' => 'Error: ' . $e->getMessage()]);
    }

    if ($body && $statusCode === 200) {
        $retArray = json_decode($body, true);

        // ---------------------------------
        // create a new order with this sku
        // ---------------------------------

        // get product object
        $product_id = null;
        $product_id = wc_get_product_id_by_sku( $retArray['data']['sku_number'] );
        $product = wc_get_product( $product_id );
        if (!$product) {
            error_log("Product not found!");
            wp_send_json_error(['message' => 'Product not found!']);
        }

        // get current user
        $user = wp_get_current_user();

        // create an empty order
        $order = wc_create_order();

        // add product to the order with 1 quantity
        $order->add_product( $product, 1 );

        // set customer id, user id
        $order->set_customer_id($user->ID);

        // set customer name
        // TODO: check if first_name and last_name are full
        $order->set_billing_first_name($user->first_name);
        $order->set_billing_last_name($user->last_name);

        // set order status to completed
        $order->set_status('wc-completed', 'OrderKeyzyStatusNote');

        // get order number for debug
        $orderNumber = $order->get_order_number();

        // sign keyzy order to avoid in keyzy_take_product_serials function
        // if the key starts with underscore '_', it's hidden
        $order->add_meta_data('_keyzy_internal_order', 'true', true);

        // discount the subtotal
        $subtotal = $order->get_subtotal();
        $order_item = new WC_Order_Item_Fee();
        $order_item->set_name('RegisterProductDiscount');
        $order_item->set_amount( -$subtotal );
        $order_item->set_total( -$subtotal );
        $order_item->save();

        // add discount to the order
        $order->add_item( $order_item );

        // calculate total price
        $order->calculate_totals();

        // save order
        $order->save();

        // Parse the name and get it
        $name = $user->first_name . " " . $user->last_name;

        try {
            $url = $connection_array['base_uri'] . 'register-products/' . $serial;
            $statusCode = 0;
            $body = '';

            $response = wp_remote_request(
                $url,
                [
                    'method' => 'PUT',
                    'timeout' => $connection_array['timeout'],
                    'sslverify' => $connection_array['verify'],
                    'body' => [
                        'app_id'   => $app_id,
                        'api_key'  => $api_key,
                        'meta'     => [
                            'user_id'   => $user->ID,
                            'order_id'  => $order->get_order_number(),
                            'sku_number' => $product->get_sku()
                        ],
                        'sku_number' => $product->get_sku(),
                        'name'      => $user->first_name . " " . $user->last_name,
                        'email'     => $user->user_email
                    ]
                ]
            );

            if (is_wp_error($response)) {
                error_log('is_wp_error: ' . $response->get_error_message());
                throw new Exception($response->get_error_message());
            }

            $statusCode = wp_remote_retrieve_response_code($response);
            $body = wp_remote_retrieve_body($response);
        } catch (Exception $e) {
            error_log('Error Message: ' . $e->getMessage());
            wp_send_json_error(['message' => 'An error occurred during the update request.']);
        }

        if ($statusCode === 200) {
            wp_send_json_success(['message' => 'Your product was successfully added.']);
        }
        // I have added these 3 checks but they are handled in the first request!
        else if ($statusCode === 422) {
            wp_send_json_error(['message' => "The serial number is not valid!"]);
        }
        else if ($statusCode === 404) {
            wp_send_json_error(['message' => "Wrong serial number!"]);
        }
        else if ($statusCode === 401) {
            wp_send_json_error(['message' => "You are not authorized!"]);
        }
        else {
            wp_send_json_error(['message' => "Unknown Error! Status code is $statusCode"]);
        }
    }

    exit;
}
?>

<div id="register-product-wrapper">
    <h3>Enter Serial Number</h3>
    <div style="width: 300px; border: 0px; border-style: solid;">
        <input style="width: 300px;" type="text" id="serial_input_id" maxlength="40" size="36" />
        <button id="serial_submit_button">
            Register
            <span id="spinner" style="display: none; margin-left: 10px;">🔄</span>
        </button>
    </div>
    <div id="result_message" style="margin-top: 10px; color: green;"></div>
</div>

<script type="text/javascript">
    document.getElementById("serial_submit_button").addEventListener("click", function (e) {
        e.preventDefault();

        const serialInput = document.getElementById("serial_input_id"); // Get the input element
        const serialValue = serialInput.value.trim(); // Trim the value to remove any leading/trailing spaces
        const resultMessage = document.getElementById("result_message");
        const submitButton = document.getElementById("serial_submit_button");
        const spinner = document.getElementById("spinner");

        if (serialValue.length === 0) {
            resultMessage.style.color = "red";
            resultMessage.innerText = "The serial number is required!";
            return;
        } else if (serialValue.length < 12) {
            resultMessage.style.color = "red";
            resultMessage.innerText = "Please check the serial number field!";
            return;
        }

        // Show the spinner and disable the button
        spinner.style.display = "inline-block";
        submitButton.disabled = true;

        // AJAX request
        const xhr = new XMLHttpRequest();
        xhr.open("POST", "<?php echo home_url($wp->request); ?>", true);
        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");

        xhr.onreadystatechange = function () {
            if (xhr.readyState === 4) {
                // Hide the spinner and re-enable the button
                spinner.style.display = "none";
                submitButton.disabled = false;

                if (xhr.status === 200) {
                    const response = JSON.parse(xhr.responseText);

                    if (response.success) {
                        resultMessage.style.color = "green";
                        resultMessage.innerText = response.data.message;
                        serialInput.value = "";
                    } else {
                        resultMessage.style.color = "red";
                        resultMessage.innerText = response.data.message;
                    }
                } else {
                    resultMessage.style.color = "red";
                    resultMessage.innerText = "An error occurred while submitting the form.";
                }
            }
        };

        xhr.send("serial=" + encodeURIComponent(serialValue));
    });
</script>
