<?php
require_once dirname(__FILE__).'/../defines.php';
global $connection_array; // from defines.php

if (isset($_POST['current_serial']) && isset($_POST['upgrade_serial'])) {
    $currentSerial = $_POST['current_serial'];
    $upgradeSerial = $_POST['upgrade_serial'];

    // get customer's app_id and api_key
    $optionInfo = get_option( 'keyzy_option_name', 'null' );

    // Keyzy app_id and api_key
    $app_id = $optionInfo['app_id'];
    $api_key = $optionInfo['api_key'];

    $res = '';
    try {
        $client = new GuzzleHttp\Client( $connection_array );

        $res = $client->request('POST', "licenses/upgrade", [
            'query' => [
                'app_id' => $app_id,
                'api_key' => $api_key,
                'current_serial' => $currentSerial,
                'upgrade_serial' => $upgradeSerial
            ]
        ]);
    }
    catch (Exception $e) {
        error_log('Error Message: ' . $e->getMessage());
    }

    if ($res) {
        $retArray = json_decode($res->getBody(), true);
        $statusCode = $res->getStatusCode();
        error_log('Status code: ' . $statusCode);
        if ($statusCode === 200) {
            echo "Upgrade completed successfully!";
        }
        else if ($statusCode === 422) {
            echo "One or both of the serial numbers is not valid!";
        }
        else if ($statusCode === 404) {
            echo "One or both of the serial numbers can't be found!";
        }
        else {
            echo "Unknown Error!";
        }
    }
}

// for $wp->request using in addEventListener
global $wp;

?>
<div id='regsiter-product-wrapper'>

    <h3>Enter Serial Numbers</h3>
    <div style="width: 300px; border: 0px; border-style: solid;">
        Enter Old Version Serial Number
        <input style="width: 300px;" type="text" id="serial_current_input_id" maxlength="40" size="36" /><br>
        Enter New Version Serial Number
        <input style="width: 300px;" type="text" id="serial_upgrade_input_id" maxlength="40" size="36" /><br>
        <a style="display: block; text-align: right;" id="serial_a_id" href="">Submit</a>
    </div>

</div>

<script type="text/javascript">

    window["serialTextElementCurrent"] = document.getElementById("serial_current_input_id");
    window["serialTextElementUpgrade"] = document.getElementById("serial_upgrade_input_id");

    window["serialAElement"] = document.getElementById("serial_a_id");

    window["serialAElement"].addEventListener("click", function(e) {
        if (window["serialTextElementCurrent"].value.trim().length === 0) {
            e.preventDefault();
            alert("The old version serial number is required!");
        }
        else if (window["serialTextElementCurrent"].value.trim().length < 12) {
            e.preventDefault();
            alert("Please check the old version serial number field!");
        }
        else if (window["serialTextElementUpgrade"].value.trim().length === 0) {
            e.preventDefault();
            alert("The new version serial number is required!");
        }
        else if (window["serialTextElementUpgrade"].value.trim().length < 12) {
            e.preventDefault();
            alert("Please check the new version serial number field!");
        }
        else {
            e.preventDefault();
            var form = document.createElement("form");
            var element1 = document.createElement("input");
            var element2 = document.createElement("input");

            form.method = "POST";
            form.action = "<?php echo home_url( $wp->request ); ?>";

            element1.value=window["serialTextElementCurrent"].value.trim();
            element1.name="current_serial";
            form.appendChild(element1);

            element2.value=window["serialTextElementUpgrade"].value.trim();
            element2.name="upgrade_serial";
            form.appendChild(element2);

            document.body.appendChild(form);

            form.submit();
        }
    });

</script>
